/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.group;

import de.z0rdak.yawp.core.group.IMemberContainer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class PlayerContainer
implements IMemberContainer {
    private final Set<String> teams;
    private final Map<UUID, String> players;
    private final String groupName;

    public PlayerContainer(class_2487 nbt) {
        this("n/a");
        this.deserializeNBT(nbt);
    }

    public PlayerContainer(String groupName) {
        this.groupName = groupName;
        this.teams = new HashSet<String>(0);
        this.players = new HashMap<UUID, String>(0);
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    public Set<String> getTeams() {
        return this.teams;
    }

    public Map<UUID, String> getPlayers() {
        return this.players;
    }

    @Override
    public boolean hasTeams() {
        return !this.teams.isEmpty();
    }

    @Override
    public boolean hasPlayers() {
        return !this.players.isEmpty();
    }

    @Override
    public boolean hasPlayer(UUID playerUUID) {
        return this.players.containsKey(playerUUID);
    }

    @Override
    public boolean hasTeam(String team) {
        return this.teams.contains(team);
    }

    @Override
    public void addPlayer(UUID uuid, String name) {
        this.players.put(uuid, name);
    }

    @Override
    public void addTeam(String team) {
        this.teams.add(team);
    }

    @Override
    public void clearPlayers() {
        this.players.clear();
    }

    @Override
    public void removePlayer(UUID playerUUID) {
        this.players.remove(playerUUID);
    }

    @Override
    public void removeTeam(String team) {
        this.teams.remove(team);
    }

    @Override
    public void clearTeams() {
        this.teams.clear();
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 nbt = new class_2487();
        class_2499 playerList = new class_2499();
        this.players.forEach((uuid, name) -> {
            class_2487 playerNBT = new class_2487();
            playerNBT.method_25927("uuid", uuid);
            playerNBT.method_10582("name", name);
            playerList.add((Object)playerNBT);
        });
        nbt.method_10566("players", (class_2520)playerList);
        class_2499 teamList = new class_2499();
        teamList.addAll((Collection)this.teams.stream().map(class_2519::method_23256).collect(Collectors.toSet()));
        nbt.method_10566("teams", (class_2520)teamList);
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.players.clear();
        class_2499 playerLists = nbt.method_10554("players", 10);
        for (int i = 0; i < playerLists.size(); ++i) {
            class_2487 playerMapping = playerLists.method_10602(i);
            this.players.put(playerMapping.method_25926("uuid"), playerMapping.method_10558("name"));
        }
        this.teams.clear();
        class_2499 teamList = nbt.method_10554("teams", 8);
        for (int i = 0; i < teamList.size(); ++i) {
            this.teams.add(teamList.method_10608(i));
        }
    }
}

